#include "flash.h" 
#include "spi.h"
#include "delay.h"   
//Mini STM32
//W25X16  
//ԭ@ALIENTEK
//2010/6/13
//V1.0
u16 SPI_FLASH_TYPE=W25Q64;//ĬϾ25Q64
//4KbytesΪһSector
//16Ϊ1Block
//W25X16
//Ϊ2Mֽ,32Block,512Sector 

//ʼSPI FLASHIO
void SPI_Flash_Init(void)
{

	GPIO_InitTypeDef GPIO_InitStructure;

  	RCC_APB2PeriphClockCmd(	RCC_APB2Periph_GPIOA, ENABLE );
	//RCC_APB2PeriphClockCmd(	RCC_APB2Periph_GPIOD, ENABLE );
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2|GPIO_Pin_4;  //SPI CS
 	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;  //
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
 	GPIO_Init(GPIOA, &GPIO_InitStructure);
 	GPIO_SetBits(GPIOA,GPIO_Pin_2);
//		GPIO_InitStructure.GPIO_Pin = GPIO_Pin_2;  //SPI CS
// 	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;  //
//	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
// 	GPIO_Init(GPIOD, &GPIO_InitStructure);
 	//GPIO_ResetBits(GPIOD,GPIO_Pin_2);
	SPI1_Init();		   //ʼSPI
	SPI1_SetSpeed(SPI_BaudRatePrescaler_4);	//Ϊ18Mʱ,ģʽ
	SPI_FLASH_TYPE=SPI_Flash_ReadID();//ȡFLASH ID.
}  

//ȡSPI_FLASH״̬Ĵ
//BIT7  6   5   4   3   2   1   0
//SPR   RV  TB BP2 BP1 BP0 WEL BUSY
//SPR:Ĭ0,״̬Ĵλ,WPʹ
//TB,BP2,BP1,BP0:FLASHд
//WEL:дʹ
//BUSY:æλ(1,æ;0,)
//Ĭ:0x00
u8 SPI_Flash_ReadSR(void)   
{  
	u8 byte=0;   
	SPI_FLASH_CS=0;                            //ʹ   
	SPI1_ReadWriteByte(W25X_ReadStatusReg);    //Ͷȡ״̬Ĵ    
	byte=SPI1_ReadWriteByte(0Xff);             //ȡһֽ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     
	return byte;   
} 
//дSPI_FLASH״̬Ĵ
//ֻSPR,TB,BP2,BP1,BP0(bit 7,5,4,3,2)д!!!
void SPI_FLASH_Write_SR(u8 sr)   
{   
	SPI_FLASH_CS=0;                            //ʹ   
	SPI1_ReadWriteByte(W25X_WriteStatusReg);   //дȡ״̬Ĵ    
	SPI1_ReadWriteByte(sr);               //дһֽ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
}   
//SPI_FLASHдʹ	
//WELλ   
void SPI_FLASH_Write_Enable(void)   
{
	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_WriteEnable);      //дʹ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
} 
//SPI_FLASHдֹ	
//WEL  
void SPI_FLASH_Write_Disable(void)   
{  
	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_WriteDisable);     //дָֹ    
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
} 			    
//ȡоƬID W25X16ID:0XEF14
u16 SPI_Flash_ReadID(void)
{
	u16 Temp = 0;	  
	SPI_FLASH_CS=0;				    
	SPI1_ReadWriteByte(0x90);//ͶȡID	    
	SPI1_ReadWriteByte(0x00); 	    
	SPI1_ReadWriteByte(0x00); 	    
	SPI1_ReadWriteByte(0x00); 	 			   
	Temp|=SPI1_ReadWriteByte(0xFF)<<8;  
	Temp|=SPI1_ReadWriteByte(0xFF);	 
	SPI_FLASH_CS=1;				    
	return Temp;
}   		    
//ȡSPI FLASH  
//ַָʼȡָȵ
//pBuffer:ݴ洢
//ReadAddr:ʼȡĵַ(24bit)
//NumByteToRead:Ҫȡֽ(65535)
void SPI_Flash_Read(u8* pBuffer,u32 ReadAddr,u16 NumByteToRead)   
{ 
 	u16 i;    												    
	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPI1_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPI1_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPI1_ReadWriteByte((u8)ReadAddr);   
    for(i=0;i<NumByteToRead;i++)
	{ 
        pBuffer[i]=SPI1_ReadWriteByte(0XFF);   //ѭ  
    }
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
}  
//SPIһҳ(0~65535)д256ֽڵ
//ַָʼд256ֽڵ
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(256),Ӧóҳʣֽ!!!	 
void SPI_Flash_Write_Page(u8* pBuffer,u32 WriteAddr,u16 NumByteToWrite)
{
 	u16 i;  
    SPI_FLASH_Write_Enable();                  //SET WEL 
	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_PageProgram);      //дҳ   
    SPI1_ReadWriteByte((u8)((WriteAddr)>>16)); //24bitַ    
    SPI1_ReadWriteByte((u8)((WriteAddr)>>8));   
    SPI1_ReadWriteByte((u8)WriteAddr);   
    for(i=0;i<NumByteToWrite;i++)SPI1_ReadWriteByte(pBuffer[i]);//ѭд  
	SPI_FLASH_CS=1;                            //ȡƬѡ 
	SPI_Flash_Wait_Busy();					   //ȴд
} 
//޼дSPI FLASH 
//ȷдĵַΧڵȫΪ0XFF,ڷ0XFFдݽʧ!
//Զҳ 
//ַָʼдָȵ,ҪȷַԽ!
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(65535)
//CHECK OK
void SPI_Flash_Write_NoCheck(u8* pBuffer,u32 WriteAddr,u16 NumByteToWrite)   
{ 			 		 
	u16 pageremain;	   
	pageremain=256-WriteAddr%256; //ҳʣֽ		 	    
	if(NumByteToWrite<=pageremain)pageremain=NumByteToWrite;//256ֽ
	while(1)
	{	   
		SPI_Flash_Write_Page(pBuffer,WriteAddr,pageremain);
		if(NumByteToWrite==pageremain)break;//д
	 	else //NumByteToWrite>pageremain
		{
			pBuffer+=pageremain;
			WriteAddr+=pageremain;	

			NumByteToWrite-=pageremain;			  //ȥѾд˵ֽ
			if(NumByteToWrite>256)pageremain=256; //һοд256ֽ
			else pageremain=NumByteToWrite; 	  //256ֽ
		}
	};	    
} 
//дSPI FLASH  
//ַָʼдָȵ
//ú!
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(65535)  		   
u8 SPI_FLASH_BUF[4096];
void SPI_Flash_Write(u8* pBuffer,u32 WriteAddr,u16 NumByteToWrite)   
{ 
	u32 secpos;
	u16 secoff;
	u16 secremain;	   
 	u16 i;    

	secpos=WriteAddr/4096;//ַ 0~511 for w25x16
	secoff=WriteAddr%4096;//ڵƫ
	secremain=4096-secoff;//ʣռС   

	if(NumByteToWrite<=secremain)secremain=NumByteToWrite;//4096ֽ
	while(1) 
	{	
		SPI_Flash_Read(SPI_FLASH_BUF,secpos*4096,4096);//
		for(i=0;i<secremain;i++)//У
		{
			if(SPI_FLASH_BUF[secoff+i]!=0XFF)break;//Ҫ  	  
		}
		if(i<secremain)//Ҫ
		{
			SPI_Flash_Erase_Sector(secpos);//
			for(i=0;i<secremain;i++)	   //
			{
				SPI_FLASH_BUF[i+secoff]=pBuffer[i];	  
			}
			SPI_Flash_Write_NoCheck(SPI_FLASH_BUF,secpos*4096,4096);//д  

		}else SPI_Flash_Write_NoCheck(pBuffer,WriteAddr,secremain);//дѾ˵,ֱдʣ. 				   
		if(NumByteToWrite==secremain)break;//д
		else//дδ
		{
			secpos++;//ַ1
			secoff=0;//ƫλΪ0 	 

		   	pBuffer+=secremain;  //ָƫ
			WriteAddr+=secremain;//дַƫ	   
		   	NumByteToWrite-=secremain;				//ֽݼ
			if(NumByteToWrite>4096)secremain=4096;	//һд
			else secremain=NumByteToWrite;			//һд
		}	 
	};	 	 
}
//оƬ
//Ƭʱ:
//W25X16:25s 
//W25X32:40s 
//W25X64:40s 
//ȴʱ䳬...
void SPI_Flash_Erase_Chip(void)   
{                                             
    SPI_FLASH_Write_Enable();                  //SET WEL 
    SPI_Flash_Wait_Busy();   
  	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_ChipErase);        //Ƭ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
	SPI_Flash_Wait_Busy();   				   //ȴоƬ
}   
//һ
//Dst_Addr:ַ 0~511 for w25x16
//һɽʱ:150ms
void SPI_Flash_Erase_Sector(u32 Dst_Addr)   
{   
	Dst_Addr*=4096;
    SPI_FLASH_Write_Enable();                  //SET WEL 	 
    SPI_Flash_Wait_Busy();   
  	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_SectorErase);      //ָ 
    SPI1_ReadWriteByte((u8)((Dst_Addr)>>16));  //24bitַ    
    SPI1_ReadWriteByte((u8)((Dst_Addr)>>8));   
    SPI1_ReadWriteByte((u8)Dst_Addr);  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
    SPI_Flash_Wait_Busy();   				   //ȴ
}  
//ȴ
void SPI_Flash_Wait_Busy(void)   
{   
	while ((SPI_Flash_ReadSR()&0x01)==0x01);   // ȴBUSYλ
}  
//ģʽ
void SPI_Flash_PowerDown(void)   
{ 
  	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_PowerDown);        //͵  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
    delay_us(3);                               //ȴTPD  
}   
//
void SPI_Flash_WAKEUP(void)   
{  
  	SPI_FLASH_CS=0;                            //ʹ   
    SPI1_ReadWriteByte(W25X_ReleasePowerDown);   //  send W25X_PowerDown command 0xAB    
	  SPI_FLASH_CS=1;                            //ȡƬѡ     	      
    delay_us(3);                               //ȴTRES1
}   


























